<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function dp_ocdi_import_files() {
    return apply_filters( 'dp_ocdi_files_args', array(
        array(
            'import_file_name'             => 'Destination Palestine',
            'categories'                   => array( 'Listing' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'includes/ocdi/demo-data.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'includes/ocdi/data/widgets.wie',
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'screenshot.png',
            'import_notice'                => esc_html__( 'Import process may take 5-10 minutes. If you facing any issues please contact our support.', 'destination-palestine' ),
            'preview_url'                  => 'https://downloads.destinationpalestine.io/demos/destination-palestine',
        ),
    ) );
}
add_filter( 'pt-ocdi/import_files', 'dp_ocdi_import_files' );


function dp_ocdi_after_import_setup( $selected_import = null ) {

    
    //set default kit
    $kit_query = new WP_Query(
        array(
            'post_type'              => 'elementor_library',
            'title'                  => 'DP Template Kit',
            'posts_per_page'         => 1,
            'no_found_rows'          => true,
            'ignore_sticky_posts'    => true,
            'update_post_term_cache' => false,
            'update_post_meta_cache' => false,
        )
    );
     
    if ( ! empty( $kit_query->post ) ) {
        $kit_id = $kit_query->post;
        $prev_kit = get_option('elementor_active_kit');
        if($prev_kit)
            update_option( 'elementor_previous_kit', $prev_kit );
        
        update_option( 'elementor_active_kit', $kit_id->ID );

    } 
    
    // elementor conditions
    $conditions = array(
        'single' => array(),
        'archive' => array(),
        'popup' => array(),
        'header' => array(),
        'footer' => array(),
    );

    if($ps_listing = get_dp_element('Listing Single')) {
        $item = array('include/singular/ps_listing');
        $conditions['single'][$ps_listing->ID] = $item;
    }

    if($post = get_dp_element('Blog Single')) {
        $item = array('include/singular/post');
        $conditions['single'][$post->ID] = $item;
    }

    if($ps_listing_archive = get_dp_element('Listings Archive')) {
        $item = array('include/archive/ps_listing_archive');
        $conditions['archive'][$ps_listing_archive->ID] = $item;
    }

    if($popup = get_dp_element('Off-Canvas Menu')) {
        $item = array('include/general');
        $conditions['popup'][$popup->ID] = $item;
    }

    if($header = get_dp_element('Header')) {
        $item = array('include/general');
        $conditions['header'][$header->ID] = $item;
    }

    if($footer = get_dp_element('Footer')) {
        $item = array('include/general');
        $conditions['footer'][$footer->ID] = $item;
    }

    
    update_option( 'elementor_pro_theme_builder_conditions', $conditions );

    //homepage
    update_option( 'show_on_front', 'page' );

    $query = new WP_Query(
        array(
            'post_type'              => 'page',
            'title'                  => 'Home',
            'posts_per_page'         => 1,
            'no_found_rows'          => true,
            'ignore_sticky_posts'    => true,
            'update_post_term_cache' => false,
            'update_post_meta_cache' => false,
        )
    );
     
    $front_page_id = null;
    if ( ! empty( $query->post ) ) {
        $front_page_id = $query->post;
    } 

    update_option( 'page_on_front', $front_page_id->ID );

    $dp_defaults = array(
        "cleanup_db_on_plugin_uninstall" => false,
        "single_post_type" => true,
        "use_minimal" => false,
        "show_labels" => true
    );

    $dp_settings = get_option('destination_palestine_settings', $dp_defaults);
    $dp_settings['single_post_type'] = true;
    update_option('destination_palestine_settings', $dp_settings);
}
add_action( 'pt-ocdi/after_import', 'dp_ocdi_after_import_setup' );



function dp_ocdi_import_settings($file) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php';
    require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-direct.php';
    $file_obj = new WP_Filesystem_Direct( array() );
    $datas = $file_obj->get_contents($file);
    $datas = json_decode( $datas, true );

    if ( count( array_filter( $datas ) ) < 1 ) {
        return;
    }

    if ( !empty($datas['page_options']) ) {
        dp_ocdi_import_page_options($datas['page_options']);
    }
    if ( !empty($datas['metadata']) ) {
        dp_ocdi_import_some_metadatas($datas['metadata']);
    }
}

function dp_ocdi_import_page_options($datas) {
    if ( $datas ) {
        foreach ($datas as $option_name => $page_id) {
            update_option( $option_name, $page_id);
        }
    }
}

function dp_ocdi_import_some_metadatas($datas) {
    if ( $datas ) {
        foreach ($datas as $slug => $post_types) {
            if ( $post_types ) {
                foreach ($post_types as $post_type => $metas) {
                    if ( $metas ) {
                        $args = array(
                            'name'        => $slug,
                            'post_type'   => $post_type,
                            'post_status' => 'publish',
                            'numberposts' => 1
                        );
                        $posts = get_posts($args);
                        if ( $posts && isset($posts[0]) ) {
                            foreach ($metas as $meta) {
                                update_post_meta( $posts[0]->ID, $meta['meta_key'], $meta['meta_value'] );
                            }
                        }
                    }
                }
            }
        }
    }
}

function dp_ocdi_before_widgets_import() {

    $sidebars_widgets = get_option('sidebars_widgets');
    $all_widgets = array();

    array_walk_recursive( $sidebars_widgets, function ($item, $key) use ( &$all_widgets ) {
        if( ! isset( $all_widgets[$key] ) ) {
            $all_widgets[$key] = $item;
        } else {
            $all_widgets[] = $item;
        }
    } );

    if( isset( $all_widgets['array_version'] ) ) {
        $array_version = $all_widgets['array_version'];
        unset( $all_widgets['array_version'] );
    }

    $new_sidebars_widgets = array_fill_keys( array_keys( $sidebars_widgets ), array() );

    $new_sidebars_widgets['wp_inactive_widgets'] = $all_widgets;
    if( isset( $array_version ) ) {
        $new_sidebars_widgets['array_version'] = $array_version;
    }

    update_option( 'sidebars_widgets', $new_sidebars_widgets );
}
add_action( 'pt-ocdi/before_widgets_import', 'dp_ocdi_before_widgets_import' );

function get_dp_element($title) {
    $kit_query = new WP_Query(
        array(
            'post_type'              => 'elementor_library',
            'title'                  => $title,
            'posts_per_page'         => 1,
            'no_found_rows'          => true,
            'ignore_sticky_posts'    => true,
            'update_post_term_cache' => false,
            'update_post_meta_cache' => false,
        )
    );
     
    if ( ! empty( $kit_query->post ) ) {
        return $kit_query->post;
    }
    return null; 
}