<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Register Customizer controls which add Elementor deeplinks
 *
 * @return void
 */
add_action( 'customize_register', 'destination_customizer_register' );
function destination_customizer_register( $wp_customize ) {
	require get_template_directory() . '/includes/customizer/elementor-upsell.php';

	$wp_customize->add_section(
		'destination_theme_options',
		[
			'title' => esc_html__( 'Header &amp; Footer', 'destination-palestine' ),
			'capability' => 'edit_theme_options',
		]
	);

	$wp_customize->add_setting(
		'destination-palestine-header-footer',
		[
			'sanitize_callback' => false,
			'transport' => 'refresh',
		]
	);

	$wp_customize->add_control(
		new DestinationPalestine\Includes\Customizer\Elementor_Upsell(
			$wp_customize,
			'destination-palestine-header-footer',
			[
				'section' => 'destination_theme_options',
				'priority' => 20,
			]
		)
	);
}


/**
 * Enqueue Customiser CSS
 *
 * @return string HTML to use in the customizer panel
 */
add_action( 'admin_enqueue_scripts', 'destination_customizer_print_styles' );
function destination_customizer_print_styles() {

	$min_suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

	wp_enqueue_style(
		'destination-palestine-customizer',
		get_template_directory_uri() . '/customizer' . $min_suffix . '.css',
		[],
		DESTINATION_PALESTINE_VERSION
	);
}
