<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Show in WP Dashboard notice about the plugin is not activated.
 *
 * @return void
 */
function destination_palestine_fail_load_admin_notice() {
	// Leave to Elementor Pro to manage this.
	if ( function_exists( 'elementor_pro_load_plugin' ) ) {
		return;
	}

	$screen = get_current_screen();
	if ( isset( $screen->parent_file ) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id ) {
		return;
	}

	if ( 'true' === get_user_meta( get_current_user_id(), '_destination_palestine_install_notice', true ) ) {
		return;
	}

	$plugin = 'elementor/elementor.php';

	$installed_plugins = get_plugins();

	$is_elementor_installed = isset( $installed_plugins[ $plugin ] );

	if ( $is_elementor_installed ) {
		if ( ! current_user_can( 'activate_plugins' ) ) {
			return;
		}

		$message = esc_html__( 'The Destination Theme is a lightweight starter theme that works perfectly with the Elementor page builder plugin. Once you activate the plugin, you are only 1 click away from building an amazing website.', 'destination-palestine' );

		$button_text = esc_html__( 'Activate Elementor', 'destination-palestine' );
		$button_link = wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1&amp;s', 'activate-plugin_' . $plugin );
	} else {
		if ( ! current_user_can( 'install_plugins' ) ) {
			return;
		}

		$message = esc_html__( 'The Destination Theme is a lightweight starter theme that works perfectly with the Elementor page builder plugin. Once you download and activate the plugin, you are only 1 click away from building an amazing website.', 'destination-palestine' );

		$button_text = esc_html__( 'Install Elementor', 'destination-palestine' );
		$button_link = wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=elementor' ), 'install-plugin_elementor' );
	}

	?>
	<style>
		.notice.destination-palestine-notice {
			border: 1px solid #ccd0d4;
			border-left: 4px solid #9b0a46 !important;
			box-shadow: 0 1px 4px rgba(0,0,0,0.15);
			display: flex;
			padding: 0px;
		}
		.rtl .notice.destination-palestine-notice {
			border-right-color: #9b0a46 !important;
		}
		.notice.destination-palestine-notice .destination-palestine-notice-aside {
			width: 50px;
			display: flex;
			align-items: start;
			justify-content: center;
			padding-top: 15px;
			background: rgba(215,43,63,0.04);
		}
		.notice.destination-palestine-notice .destination-palestine-notice-aside img{
			width: 1.5rem;
		}
		.notice.destination-palestine-notice .destination-palestine-notice-inner {
			display: table;
			padding: 20px 0px;
			width: 100%;
		}
		.notice.destination-palestine-notice .destination-palestine-notice-content {
			padding: 0 20px;
		}
		.notice.destination-palestine-notice p {
			padding: 0;
			margin: 0;
		}
		.notice.destination-palestine-notice h3 {
			margin: 0 0 5px;
		}
		.notice.destination-palestine-notice .destination-palestine-install-now {
			display: block;
			margin-top: 15px;
		}
		.notice.destination-palestine-notice .destination-palestine-install-now .destination-palestine-install-button {
			background: #127DB8;
			border-radius: 3px;
			color: #fff;
			text-decoration: none;
			height: auto;
			line-height: 20px;
			padding: 0.4375rem 0.75rem;
			text-transform: capitalize;
		}
		.notice.destination-palestine-notice .destination-palestine-install-now .destination-palestine-install-button:active {
			transform: translateY(1px);
		}
		@media (max-width: 767px) {
			.notice.destination-palestine-notice.destination-palestine-install-elementor {
				padding: 0px;
			}
			.notice.destination-palestine-notice .destination-palestine-notice-inner {
				display: block;
				padding: 10px;
			}
			.notice.destination-palestine-notice .destination-palestine-notice-inner .destination-palestine-notice-content {
				display: block;
				padding: 0;
			}
			.notice.destination-palestine-notice .destination-palestine-notice-inner .destination-palestine-install-now {
				display: none;
			}
		}
	</style>
	<script>jQuery( function( $ ) {
			$( 'div.notice.destination-palestine-install-elementor' ).on( 'click', 'button.notice-dismiss', function( event ) {
				event.preventDefault();

				$.post( ajaxurl, {
					action: 'destination_palestine_set_admin_notice_viewed'
				} );
			} );
		} );</script>
	<div class="notice updated is-dismissible destination-palestine-notice destination-palestine-install-elementor">
		<div class="destination-palestine-notice-aside">
			<img src="<?php echo esc_url( get_template_directory_uri() ) . '/assets/images/elementor-notice-icon.svg'; ?>" alt="<?php echo esc_attr__( 'Get Elementor', 'destination-palestine' ); ?>" />
		</div>
		<div class="destination-palestine-notice-inner">
			<div class="destination-palestine-notice-content">
				<h3><?php echo esc_html__( 'Thanks for installing the Destination Palestine Theme!', 'destination-palestine' ); ?></h3>
				<p><?php echo esc_html( $message ); ?></p>
				<div class="destination-palestine-install-now">
					<a class="destination-palestine-install-button" href="<?php echo esc_attr( $button_link ); ?>"><?php echo esc_html( $button_text ); ?></a>
				</div>
			</div>
		</div>
	</div>
	<?php
}

/**
 * Set Admin Notice Viewed.
 *
 * @return void
 */
function ajax_destination_palestine_set_admin_notice_viewed() {
	update_user_meta( get_current_user_id(), '_destination_palestine_install_notice', 'true' );
	die;
}

add_action( 'wp_ajax_destination_palestine_set_admin_notice_viewed', 'ajax_destination_palestine_set_admin_notice_viewed' );
if ( ! did_action( 'elementor/loaded' ) ) {
	add_action( 'admin_notices', 'destination_palestine_fail_load_admin_notice' );
}
