<?php 
$start_of_week = (int) get_option( 'start_of_week', 0 );

$days = array();
foreach ($value as $day) {
	$start = $helper->get_date_from_time($day->starthours);
	$end = $helper->get_date_from_time($day->endhours);
	$days[$day->day] = array('starthours' => $start, 'endhours' => $end);
}
?>
<table class="compact">
<?php for($i = 0; $i < 7; $i++): ?>
	<tr>
		<td><?php print __(jddayofweek(($i+6)%7,1)); ?></td>
		<td class="text-right">
			<?php if(isset($days[$i])): ?>
				<?php print $days[$i]['starthours']; ?> - <?php print $days[$i]['endhours']; ?>
			<?php else: ?>
				<?php print __('Closed', 'destination_palestine'); ?>
			<?php endif; ?>
		</td>
	</tr>
<?php endfor; ?>
	
</table>
<dl>

</dl>